#!/bin/bash
clear
    echo ""
    echo ""
    echo ""
    echo ""
    echo ""
    echo " __    __  _____   _______   _____   _   _   _____   _____   _   _   _____ "
    echo " \ \  / / |  ___| |__   __| |  _  | | | | | |  _  | |  _  \ | | / / |  _  |"
    echo "  \ \/ /  | |        | |    | |_| | | |_| | | | | | | |_| / | |/ /  | |_| |"
    echo "   \  /   | |        | |    |  _  | |  _  | | | | | |  _ |  |   (   |  _  |"
    echo "   / /    | |___     | |    | | | | | | | | | |_| | | |_| \ | |\ \  | | | |"
    echo "  /_/     |_____|    |_|    |_| |_| |_| |_| |_____| |_____/ |_| \_\ |_| |_|"
    
    echo "                      _______   _____   _____  __    __  "
    echo "                     |__   __| |  ___| | ____| \ \  / / "
    echo "                        | |    | |___  | |      \ \/ / "
    echo "                        | |    |  ___| | |       \  / "
    echo "                        | |    | |___  | |       / / "
    echo "                        |_|    |_____| |_|      /_/ "
    echo ""
  
timeout 2s sleep 2s
clear 

echo "Создаем структуру каталогов для сервера" 
mkdir -p /opt/tegu
cd /opt/tegu
mkdir -p bin
mkdir -p sbin
mkdir -p data
mkdir -p certs
timeout 1s sleep 1s

# отображаем проверку созданных каталогов: tegu и вложенные папки bin, sbin, data, certs
if [ -d "/opt/tegu" ]; then
  echo "/opt/tegu - OK"
else
  echo "/opt/tegu - ERR"
fi
timeout 1s sleep 1s
if [ -d "/opt/tegu/bin" ]; then
  echo "/opt/tegu/bin - OK"
else
  echo "/opt/tegu/bin - ERR"
fi
timeout 1s sleep 1s
if [ -d "/opt/tegu/sbin" ]; then
  echo "/opt/tegu/sbin - OK"
else
  echo "/opt/tegu/sbin - ERR"
fi
timeout 1s sleep 1s
if [ -d "/opt/tegu/data" ]; then
  echo "/opt/tegu/data - OK"
else
  echo "/opt/tegu/data - ERR"
fi
timeout 1s sleep 1s
if [ -d "/opt/tegu/certs" ]; then
  echo "/opt/tegu/certs - OK"
else
  echo "/opt/tegu/certs - ERR"
fi
timeout 4s sleep 4s
clear 

#Создаем временную папку для дистрибутива. 
mkdir -p /opt/tmp
cd /opt/tmp

echo "Скачиваем актуальную версию дистрибутива Tegu"
timeout 3s sleep 3s
if [ -f tegu-ent-latest-x86_64.tar.gz ]; then rm tegu-ent-latest-x86_64.tar.gz; fi 
wget --no-check-certificate https://downloads.mbk-lab.ru/stable/tegu-ent-latest-x86_64.tar.gz

timeout 4s sleep 4s
clear 

echo "Распаковываем архив" 
tar -xvf tegu-ent-latest-x86_64.tar.gz

timeout 4s sleep 4s
clear 
echo "Копируем исполняемые файлы в рабочий каталог" 
cd /opt/tmp/
find . -type d -name "bin" -exec cp -r {} /opt/tegu/ \;
find . -type d -name "sbin" -exec cp -r {} /opt/tegu/ \;
timeout 1s sleep 1s

# проверяем и отображаем скопировалась ли папка bin или нет

cd /opt/tegu/bin/

FILE=teguctl
[ -f teguctl ] && echo "/opt/tegu/bin/teguctl - OK" || echo "/opt/tegu/bin/teguctl - ERR" 
timeout 1s sleep 1s

# проверяем и отображаем скопировалась ли папка sbin или нет

cd /opt/tegu/sbin/
FILE=tegu
[ -f tegu ] && echo "/opt/tegu/bin/tegu - OK" || echo "/opt/tegu/bin/tegu - ERR"

timeout 4s sleep 4s
clear 

echo "Назначаем пользователя и права" 

chown -R mail: /opt/tegu/data
chown -R mail: /opt/tegu/certs
chgrp -R mail /opt/tegu/bin
chgrp -R mail /opt/tegu/sbin
chmod 750 /opt/tegu/data
chmod 750 /opt/tegu/certs
chmod -R 750 /opt/tegu/sbin
chmod -R 750 /opt/tegu/bin
timeout 1s sleep 1s
echo "chown -R mail: /opt/tegu/{data,certs} OK"
timeout 1s sleep 1s
echo "chgrp -R mail /opt/tegu/{bin,sbin} OK"
timeout 1s sleep 1s
echo "chmod 750 /opt/tegu/{data,certs} OK"
timeout 1s sleep 1s
echo "chmod -R 750 /opt/tegu/sbin OK"
timeout 1s sleep 1s
echo "chmod -R 750 /opt/tegu/bin OK"
timeout 2s sleep 2s

clear 
echo "Проверяем правильность создания каталогов и файлов, а также их прав"
ls -l /opt/tegu

timeout 4s sleep 4s
clear 

echo "Настраиваем механизм запуска и управления" 

cd /etc/systemd/system
touch tegu.service
echo '[Unit]
Description=Tegu. MBK-Lab Mail Server

[Service]
ExecStart=/opt/tegu/sbin/tegu
User=mail
Group=mail
UMask=0007
RestartSec=10
Restart=always

[Install]
WantedBy=multi-user.target' > tegu.service

cat /etc/systemd/system/tegu.service

timeout 4s sleep 4s
clear 

echo "Разрешаем запуск почтового сервера от имени непривилегированного пользователя" 

setcap CAP_NET_BIND_SERVICE=+eip /opt/tegu/sbin/tegu
timeout 1s sleep 1s
echo "setcap CAP_NET_BIND_SERVICE=+eip /opt/tegu/sbin/tegu OK"

timeout 4s sleep 4s
clear 

echo "Создаем конфигурационный файл в /etc/tegu.conf" 

cd /etc
touch tegu.conf
echo '[global]
dataDir = /opt/tegu/data

[Log]
debug = true

[WEB]
adminPassword = admin
httpPort = 8888
httpsPort = 9999
ctlPort = 8899' > tegu.conf

cat /etc/tegu.conf

timeout 3s sleep 3s
clear 

echo "Устанавливаем права на файл /etc/tegu.conf" 
chown root.mail /etc/tegu.conf
chmod 640 /etc/tegu.conf

timeout 1s sleep 1s
echo "chown root.mail /etc/tegu.conf OK"
timeout 1s sleep 1s
echo "chmod 640 /etc/tegu.conf OK"

timeout 2s sleep 2s
clear 

echo "Разрешаем автозапуск сервера во время загрузки ОС"

systemctl enable tegu.service

timeout 2s sleep 2s
clear 

echo "Запускаем почтовый сервер" 

systemctl start tegu.service
timeout 1s sleep 1s
echo "systemctl start tegu.service"
timeout 2s sleep 2s
clear 

echo "Контролируем запуск сервиса tegu" 
systemctl status tegu.service

timeout 2s sleep 2s
echo "Установка завершена" 
